<?php
/**
 * Copyright 2015 Adobe
 * All Rights Reserved.
 */

namespace Magento\Setup\Model;

/**
 * Class PhpInformation
 *
 * Provides information and checks about the current and required PHP settings.
 */
class PhpInformation
{

    /**
     * Allowed XDebug nested level
     */
    const XDEBUG_NESTED_LEVEL = 200;

    /**
     * List of currently installed extensions
     *
     * @var array
     */
    protected $current = [];

    /**
     * Returns minimum required XDebug nested level
     * @return int
     */
    public function getRequiredMinimumXDebugNestedLevel()
    {
        return self::XDEBUG_NESTED_LEVEL;
    }

    /**
     * Retrieve list of currently installed extensions
     *
     * @return array
     */
    public function getCurrent()
    {
        if (!$this->current) {
            $this->current = array_map(function ($ext) {
                return str_replace(' ', '-', strtolower($ext));
            }, get_loaded_extensions());
        }
        return $this->current;
    }
}
