<?php
/**
 * Copyright 2016 Adobe
 * All Rights Reserved.
 */
namespace Magento\Framework\View;

/**
 * Model which allows access to handles containing ID of the rendered entity
 */
class EntitySpecificHandlesList
{
    /**
     * The list of handles containing entity ID
     *
     * @var string[]
     */
    private $handles = [];

    /**
     * Add handle to the list of handles containing entity ID
     *
     * @param string $handle
     * @return void
     */
    public function addHandle($handle)
    {
        $this->handles[] = $handle;
    }

    /**
     * Get list of handles containing entity ID
     *
     * @return string[]
     */
    public function getHandles()
    {
        return $this->handles;
    }
}
