<?php
/**
 * Copyright 2015 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\Framework\Shell\Test\Unit;

use Magento\Framework\Shell\CommandRenderer;
use PHPUnit\Framework\TestCase;

class CommandRendererTest extends TestCase
{
    /**
     * @param $expectedCommand
     * @param $actualCommand
     * @param $testArguments
     * @dataProvider commandsDataProvider
     */
    public function testRender($expectedCommand, $actualCommand, $testArguments)
    {
        $commandRenderer = new CommandRenderer();
        $this->assertEquals(
            $expectedCommand,
            $commandRenderer->render($actualCommand, $testArguments)
        );
    }

    /**
     * @return array
     */
    public static function commandsDataProvider()
    {
        $testArgument  = 'argument';
        $testArgument2 = 'argument2';

        $expectedCommand = "php -r %s 2>&1 | grep %s 2>&1";
        $expectedCommandArgs = "php -r '" . $testArgument . "' 2>&1 | grep '" . $testArgument2 . "' 2>&1";

        return [
            [$expectedCommand, 'php -r %s | grep %s', []],
            [$expectedCommand, 'php -r %s 2>&1 | grep %s', []],
            [$expectedCommand, 'php -r %s 2>&1 2>&1 | grep %s', []],
            [$expectedCommandArgs, 'php -r %s | grep %s', [$testArgument, $testArgument2]],
            [$expectedCommandArgs, 'php -r %s 2>&1 | grep %s', [$testArgument, $testArgument2]],
            [$expectedCommandArgs, 'php -r %s 2>&1 2>&1 | grep %s', [$testArgument, $testArgument2]],
        ];
    }
}
