<?php
/**
 * Copyright 2015 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\Framework\Exception\Test\Unit;

use Magento\Framework\Exception\AuthenticationException;
use Magento\Framework\Phrase;
use PHPUnit\Framework\TestCase;

class AuthenticationExceptionTest extends TestCase
{
    /**
     * @return void
     */
    public function testConstructor()
    {
        $authenticationException = new AuthenticationException(
            new Phrase(
                'An authentication error occurred. Verify and try again.',
                ['consumer_id' => 1, 'resources' => 'record2']
            )
        );
        $this->assertSame(
            'An authentication error occurred. Verify and try again.',
            $authenticationException->getMessage()
        );
    }
}
