<?php
/**
 * Copyright 2017 Adobe
 * All Rights Reserved.
 */
namespace Magento\Framework\Console\Exception;

use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Phrase;

/**
 * The default exception for missing write permissions on compilation generated folder.
 */
class GenerationDirectoryAccessException extends FileSystemException
{
    /**
     * @inheritdoc
     */
    public function __construct(?Phrase $phrase = null, ?\Exception $cause = null, $code = 0)
    {
        $phrase = $phrase ?: new Phrase(
            'Command line user does not have read and write permissions on '
            . $this->getDefaultDirectoryPath(DirectoryList::GENERATED) . ' directory. '
            . 'Please address this issue before using Magento command line.'
        );

        parent::__construct($phrase, $cause, $code);
    }

    /**
     * Get default directory path by code
     *
     * @param string $code
     * @return string
     */
    private function getDefaultDirectoryPath($code)
    {
        $config = DirectoryList::getDefaultConfig();
        $result = '';

        if (isset($config[$code][DirectoryList::PATH])) {
            $result = $config[$code][DirectoryList::PATH];
        }

        return $result;
    }
}
