<?php
/**
 * Copyright 2015 Adobe
 * All Rights Reserved.
 */
namespace Magento\Framework\Code\Test\Unit\Validator;

use PHPUnit\Framework\TestCase;
use Magento\Framework\Code\Validator\ArgumentSequence;
use Magento\Framework\Exception\ValidatorException;

require_once '_files/ClassesForArgumentSequence.php';
class ArgumentSequenceTest extends TestCase
{
    /**
     * @var ArgumentSequence
     */
    protected $_validator;

    /**
     * @var string
     */
    protected $_fixturePath;

    protected function setUp(): void
    {
        $path = realpath(__DIR__) . '/_files/ClassesForArgumentSequence.php';
        $this->_fixturePath = str_replace('\\', '/', $path);
        $this->_validator = new ArgumentSequence();

        /** Build internal cache */
        $this->_validator->validate('\ArgumentSequence\ParentClass');
    }

    public function testValidSequence()
    {
        $this->assertTrue($this->_validator->validate('\ArgumentSequence\ValidChildClass'));
    }

    public function testInvalidSequence()
    {
        $expectedSequence = '$contextObject, $parentRequiredObject, $parentRequiredScalar, ' .
            '$childRequiredObject, $childRequiredScalar, $parentOptionalObject, $data, $parentOptionalScalar, ' .
            '$childOptionalObject, $childOptionalScalar';

        $actualSequence = '$contextObject, $childRequiredObject, $parentRequiredObject, $parentRequiredScalar, ' .
            '$childRequiredScalar, $parentOptionalObject, $data, $parentOptionalScalar, ' .
            '$childOptionalObject, $childOptionalScalar';

        $message = 'Incorrect argument sequence in class %s in ' .
            $this->_fixturePath .
            PHP_EOL .
            'Required: %s' .
            PHP_EOL .
            'Actual  : %s' .
            PHP_EOL;
        $message = sprintf($message, '\ArgumentSequence\InvalidChildClass', $expectedSequence, $actualSequence);
        $this->expectException(ValidatorException::class);
        $this->expectExceptionMessage($message);
        $this->_validator->validate('\ArgumentSequence\InvalidChildClass');
    }
}
