<?php
/**
 * Copyright 2015 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\Framework\App\Test\Unit\DefaultPath;

use Magento\Framework\App\DefaultPath\DefaultPath;
use PHPUnit\Framework\TestCase;

class DefaultPathTest extends TestCase
{
    /**
     * @param array $parts
     * @param string $code
     * @param string $result
     * @dataProvider dataProviderGetPart
     */
    public function testGetPart($parts, $code, $result)
    {
        $model = new DefaultPath($parts);
        $this->assertEquals($result, $model->getPart($code));
    }

    /**
     * @return array
     */
    public static function dataProviderGetPart()
    {
        return [
            [
                ['code' => 'value'],
                'code',
                'value',
            ],
            [
                ['code' => 'value'],
                'other_code',
                null,
            ],
        ];
    }
}
