<?php
/**
 * Copyright 2015 Adobe
 * All Rights Reserved.
 */
namespace Magento\Framework\App\Scope;

use Magento\Framework\App\ScopeResolverPool;
use Magento\Framework\Option\ArrayInterface;

class Source implements ArrayInterface
{
    /**
     * @var ScopeResolverPool
     */
    protected $scopeResolverPool;

    /**
     * @var string
     */
    protected $scope;

    /**
     * @param ScopeResolverPool $scopeResolverPool
     * @param string $scope
     */
    public function __construct(
        ScopeResolverPool $scopeResolverPool,
        $scope
    ) {
        $this->scopeResolverPool = $scopeResolverPool;
        $this->scope = $scope;
    }

    /**
     * Return array of scope names
     *
     * @return array
     */
    public function toOptionArray()
    {
        $scopes = $this->scopeResolverPool->get($this->scope)->getScopes();
        $array = [];
        foreach ($scopes as $scope) {
            $array[] = ['value' => $scope->getId(), 'label' => $scope->getName()];
        }
        return $array;
    }
}
