<?php
/**
 * Copyright 2017 Adobe
 * All Rights Reserved.
 */
namespace Magento\Framework\App;

/**
 * Interface provides low-level access to Magento Application Request and represent it as a simple string.
 * This interface does not define format of the request content.
 * Clients of this interface must be able to validate syntax of request and parse it.
 *
 * To read already parsed request data use \Magento\Framework\App\RequestInterface.
 *
 * @api
 * @since 101.0.0
 */
interface PlainTextRequestInterface
{
    /**
     * Returns textual representation of request to Magento.
     *
     * @return string
     * @since 101.0.0
     */
    public function getContent();
}
