<?php
/**
 * Copyright 2017 Adobe
 * All Rights Reserved.
 */
namespace Magento\TestFramework\Utility;

class ClassNameExtractor
{
    /**
     * Get class name with namespace
     *
     * @param string $fileContent
     * @return bool|string
     */
    public function getNameWithNamespace($fileContent)
    {
        $namespace = $this->getNamespace($fileContent);
        $name = $this->getName($fileContent);
        if ($name) {
            return $namespace ? $namespace . '\\' . $name : $name;
        }
        return false;
    }

    /**
     * Get class name
     *
     * @param string $fileContent
     * @return string|bool
     */
    public function getName($fileContent)
    {
        $namespace = $this->getNamespace($fileContent);
        if (isset($namespace)) {
            preg_match_all(
                '/^\s*(class|abstract\sclass|interface)\s+([a-z0-9]+)(\s+(extends|implements)|\s*$)/im',
                $fileContent,
                $classMatches
            );
            if (isset($classMatches[2][0])) {
                return $classMatches[2][0];
            }
        }
        return false;
    }

    /**
     * Get class namespace
     *
     * @param string $fileContent
     * @return string|bool
     */
    public function getNamespace($fileContent)
    {
        preg_match_all(
            '/namespace\s([a-z0-9\\\\]+);/im',
            $fileContent,
            $namespaceMatches
        );
        if (isset($namespaceMatches[1][0])) {
            return $namespaceMatches[1][0];
        }
        return false;
    }
}
