<?php
/**
 * Test case for \Magento\Framework\Profiler\Driver\Standard\Output\Csvfile
 *
 * Copyright 2014 Adobe
 * All Rights Reserved.
 */
namespace Magento\Framework\Profiler\Driver\Standard\Output;

class CsvfileTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var \Magento\Framework\Profiler\Driver\Standard\Output\Csvfile
     */
    protected $_output;

    /**
     * @var string
     */
    protected $_outputFile;

    protected function setUp(): void
    {
        $this->_outputFile = tempnam(sys_get_temp_dir(), __CLASS__);
    }

    /**
     * Test display method
     *
     * @dataProvider displayDataProvider
     * @param string $statFile
     * @param string $expectedFile
     * @param string $delimiter
     * @param string $enclosure
     */
    public function testDisplay($statFile, $expectedFile, $delimiter = ',', $enclosure = '"')
    {
        $this->_output = new \Magento\Framework\Profiler\Driver\Standard\Output\Csvfile(
            ['filePath' => $this->_outputFile, 'delimiter' => $delimiter, 'enclosure' => $enclosure]
        );
        $stat = include $statFile;
        $this->_output->display($stat);
        $this->assertFileEquals($expectedFile, $this->_outputFile);
    }

    /**
     * @return array
     */
    public static function displayDataProvider()
    {
        return [
            'Default delimiter & enclosure' => [
                'statFile' => __DIR__ . '/_files/timers.php',
                'expectedFile' => __DIR__ . '/_files/output_default.csv',
            ],
            'Custom delimiter & enclosure' => [
                'statFile' => __DIR__ . '/_files/timers.php',
                'expectedFile' => __DIR__ . '/_files/output_custom.csv',
                '.',
                '`',
            ]
        ];
    }
}
