<?php
/**
 * Fixture for Customer List method.
 *
 * Copyright 2019 Adobe
 * All Rights Reserved.
 */
declare(strict_types = 1);

use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Magento/Customer/_files/customer_rollback.php');

/** @var Registry $registry */
$registry = Bootstrap::getObjectManager()->get(Registry::class);
$registry->unregister('isSecureArea');
$registry->register('isSecureArea', true);

/** @var CustomerRepositoryInterface $customerRepository */
$customerRepository = Bootstrap::getObjectManager()->get(CustomerRepositoryInterface::class);
try {
    $customer = $customerRepository->get('customer_two@example.com');
    $customerRepository->delete($customer);
} catch (NoSuchEntityException $e) {
    /** Tests which are wrapped with MySQL transaction clear all data by transaction rollback. */
}

$registry->unregister('isSecureArea');
$registry->register('isSecureArea', false);
