<?php
/**
 * Customer default address fixture with entity_id = 2,
 * this fixture also inherit other fixtures for creating simple product, a customer with entity_id=1
 * and default customer address.
 * It also call a new fixture to update customer address `input_validation` rule for `street` field.
 *
 * Copyright 2021 Adobe
 * All Rights Reserved.
 */
use Magento\Customer\Model\CustomerRegistry;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Magento/Catalog/_files/product_simple.php');
Resolver::getInstance()->requireDataFixture('Magento/Customer/_files/customer.php');
Resolver::getInstance()->requireDataFixture('Magento/Customer/_files/customer_address.php');

/** @var \Magento\Customer\Model\Address $customerAddress */
$customerAddress = \Magento\TestFramework\Helper\Bootstrap::getObjectManager()
    ->create(\Magento\Customer\Model\Address::class);
/** @var CustomerRegistry $customerRegistry */
$customerRegistry = \Magento\TestFramework\Helper\Bootstrap::getObjectManager()
    ->get(CustomerRegistry::class);
$customerAddress->isObjectNew(true);
$customerAddress->setData(
    [
        'entity_id' => 2,
        'attribute_set_id' => 2,
        'telephone' => 3234676,
        'postcode' => 47676,
        'country_id' => 'US',
        'city' => 'CityX',
        'street' => ['Black str 48'],
        'lastname' => 'Smith',
        'firstname' => 'John',
        'parent_id' => 1,
        'region_id' => 1,
    ]
)->setCustomerId(
    1
);

$customerAddress->save();
$customerRegistry->remove($customerAddress->getCustomerId());

Resolver::getInstance()->requireDataFixture('Magento/Customer/_files/customer_address_attribute_update.php');
