<?php
/**
 * Copyright 2015 Adobe
 * All Rights Reserved.
 */
namespace Magento\CatalogUrlRewrite\Plugin\Catalog\Block\Adminhtml\Category\Tab;

use Magento\Catalog\Model\Category\DataProvider;
use Magento\Eav\Model\Config as EavConfig;
use Magento\TestFramework\Helper\Bootstrap;

/**
 * @magentoAppArea adminhtml
 */
class AttributesTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var DataProvider
     */
    private $dataProvider;

    /**
     * @var \Magento\Eav\Model\Entity\Type
     */
    private $entityType;

    /**
     * {@inheritDoc}
     */
    protected function setUp(): void
    {
        parent::setUp();
        $objectManager = Bootstrap::getObjectManager();
        $this->dataProvider = $objectManager->create(
            DataProvider::class,
            [
                'name' => 'category_form_data_source',
                'primaryFieldName' => 'entity_id',
                'requestFieldName' => 'id'
            ]
        );

        $this->entityType = $objectManager->create(EavConfig::class)->getEntityType('catalog_category');
    }

    /**
     * test \Magento\CatalogUrlRewrite\Plugin\Catalog\Block\Adminhtml\Category\Tab\Attributes::afterGetAttributesMeta
     * @return void
     */
    public function testGetAttributesMeta()
    {
        $meta = $this->dataProvider->getMeta();
        $this->assertArrayHasKey('url_key', $meta['search_engine_optimization']['children']);
        $urlKeyData = $meta['search_engine_optimization']['children']['url_key']['arguments']['data']['config'];
        $this->assertEquals('text', $urlKeyData['dataType']);
        $this->assertEquals('input', $urlKeyData['formElement']);
        $this->assertTrue($urlKeyData['visible']);
        $this->assertFalse($urlKeyData['required']);
        $this->assertEquals('[STORE VIEW]', $urlKeyData['scopeLabel']);
    }
}
