<?php
/**
 * Copyright 2013 Adobe
 * All Rights Reserved.
 */
namespace Magento\CatalogInventory\Model\Stock;

class ItemTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var \Magento\CatalogInventory\Model\Stock\Item
     */
    protected $_model;

    protected function setUp(): void
    {
        $this->_model = \Magento\TestFramework\Helper\Bootstrap::getObjectManager()->create(
            \Magento\CatalogInventory\Model\Stock\Item::class
        );
    }

    /**
     * @magentoDataFixture Magento/Catalog/_files/products.php
     */
    public function testSaveWithNullQty()
    {
        /** @var \Magento\Catalog\Model\Product $product */
        $product = \Magento\TestFramework\Helper\Bootstrap::getObjectManager()
            ->get(\Magento\Catalog\Model\Product::class);

        $product->loadByAttribute('sku', 'simple');

        /** @var \Magento\CatalogInventory\Model\Stock\StockItemRepository $stockItemRepository */
        $stockItemRepository = $product = \Magento\TestFramework\Helper\Bootstrap::getObjectManager()
            ->create(\Magento\CatalogInventory\Model\Stock\StockItemRepository::class);

        /** @var \Magento\CatalogInventory\Api\StockItemCriteriaInterface $stockItemCriteria */
        $stockItemCriteria = $product = \Magento\TestFramework\Helper\Bootstrap::getObjectManager()
            ->create(\Magento\CatalogInventory\Api\StockItemCriteriaInterface::class);

        $savedStockItem = current($stockItemRepository->getList($stockItemCriteria)->getItems());
        $savedStockItemId = $savedStockItem->getItemId();

        $savedStockItem->setQty(null);
        $savedStockItem->save();

        $savedStockItem->setQty(2);
        $savedStockItem->save();
        $this->assertEquals('2.0000', $savedStockItem->load($savedStockItemId)->getQty());

        $savedStockItem->setQty(0);
        $savedStockItem->save();
        $this->assertEquals('0.0000', $savedStockItem->load($savedStockItemId)->getQty());

        $savedStockItem->setQty(null);
        $savedStockItem->save();

        $this->assertNull($savedStockItem->load($savedStockItemId)->getQty());
    }

    /**
     * @magentoDataFixture Magento/Catalog/_files/products.php
     */
    public function testStockStatusChangedAuto()
    {
        /** @var \Magento\CatalogInventory\Model\Stock\StockItemRepository $stockItemRepository */
        $stockItemRepository = $product = \Magento\TestFramework\Helper\Bootstrap::getObjectManager()
            ->create(\Magento\CatalogInventory\Model\Stock\StockItemRepository::class);

        /** @var \Magento\CatalogInventory\Api\StockItemCriteriaInterface $stockItemCriteria */
        $stockItemCriteria = $product = \Magento\TestFramework\Helper\Bootstrap::getObjectManager()
            ->create(\Magento\CatalogInventory\Api\StockItemCriteriaInterface::class);

        $savedStockItem = current($stockItemRepository->getList($stockItemCriteria)->getItems());

        $savedStockItem->setQty(1);
        $savedStockItem->save();

        $this->assertEquals(0, $savedStockItem->getStockStatusChangedAuto());

        $savedStockItem->setStockStatusChangedAutomaticallyFlag(1);
        $savedStockItem->save();
        $this->assertEquals(1, $savedStockItem->getStockStatusChangedAuto());
    }

    /**
     * @magentoConfigFixture current_store cataloginventory/item_options/enable_qty_increments 1
     */
    public function testSetGetEnableQtyIncrements()
    {
        $this->assertFalse($this->_model->getEnableQtyIncrements());

        $this->_model->setUseConfigEnableQtyInc(true);
        $this->assertTrue($this->_model->getEnableQtyIncrements());
    }
}
