<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\Analytics\Controller\Adminhtml\Reports;

use Magento\TestFramework\TestCase\AbstractBackendController;

/**
 * @magentoAppArea adminhtml
 */
class ShowTest extends AbstractBackendController
{
    private const REPORT_HOST = 'experienceleague.adobe.com';
    /**
     * @var string
     */
    protected $resource = 'Magento_Analytics::advanced_reporting';
    /**
     * @var string
     */
    protected $uri = 'backend/analytics/reports/show';
    /**
     * @inheritDoc
     */
    public function testAclHasAccess()
    {
        parent::testAclHasAccess();
        $this->assertSame(302, $this->getResponse()->getHttpResponseCode());
        $this->assertSame(self::REPORT_HOST, $this->getResponse()->getHeader('location')->uri()->getHost());
    }
}
