<?php
/**
 * Copyright 2012 Adobe
 * All Rights Reserved.
 */

/**
 * Test class for \Magento\TestFramework\Event\Magento.
 */
namespace Magento\Test\Event;

class MagentoTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var \Magento\TestFramework\Event\Magento
     */
    protected $_object;

    /**
     * @var \Magento\TestFramework\EventManager|\PHPUnit\Framework\MockObject\MockObject
     */
    protected $_eventManager;

    protected function setUp(): void
    {
        $this->_eventManager = $this->getMockBuilder(\Magento\TestFramework\EventManager::class)
            ->onlyMethods(['fireEvent'])
            ->setConstructorArgs([[]])
            ->getMock();
        $this->_object = new \Magento\TestFramework\Event\Magento($this->_eventManager);
    }

    protected function tearDown(): void
    {
        \Magento\TestFramework\Event\Magento::setDefaultEventManager(null);
    }

    public function testConstructorDefaultEventManager()
    {
        \Magento\TestFramework\Event\Magento::setDefaultEventManager($this->_eventManager);
        $this->_object = new \Magento\TestFramework\Event\Magento();
        $this->testInitStoreAfter();
    }

    /**
     * @dataProvider constructorExceptionDataProvider
     * @param mixed $eventManager
     */
    public function testConstructorException($eventManager)
    {
        $this->expectException(\Magento\Framework\Exception\LocalizedException::class);

        new \Magento\TestFramework\Event\Magento($eventManager);
    }

    public static function constructorExceptionDataProvider()
    {
        return ['no event manager' => [null], 'not an event manager' => [new \stdClass()]];
    }

    public function testInitStoreAfter()
    {
        $this->_eventManager->expects($this->once())->method('fireEvent')->with('initStoreAfter');
        $this->_object->execute($this->createMock(\Magento\Framework\Event\Observer::class));
    }
}
