<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\Store\Model\StoreSwitcher;

/**
 * Store switcher redirect data post-processor interface
 *
 * @api
 */
interface RedirectDataPostprocessorInterface
{
    /**
     * Process data redirected from origin source
     *
     * @param ContextInterface $context
     * @param array $data
     */
    public function process(ContextInterface $context, array $data): void;
}
