<?php
/**
 * Copyright 2011 Adobe
 * All Rights Reserved.
 */
namespace Magento\Paypal\Block\Hosted\Pro;

/**
 * Hosted Pro iframe block
 */
class Iframe extends \Magento\Paypal\Block\Iframe
{
    /**
     * Internal constructor Set payment method code
     *
     * @return void
     */
    protected function _construct()
    {
        parent::_construct();
        $this->_paymentMethodCode = \Magento\Paypal\Model\Config::METHOD_HOSTEDPRO;
    }

    /**
     * Get iframe action URL
     *
     * @return string
     */
    public function getFrameActionUrl()
    {
        return $this->_getOrder()->getPayment()->getAdditionalInformation('secure_form_url');
    }
}
