<?php
/**
 * Copyright 2013 Adobe
 * All Rights Reserved.
 */
namespace Magento\GoogleOptimizer\Helper;

use Magento\Framework\Data\Form as DataForm;
use Magento\GoogleOptimizer\Model\Code as ModelCode;

/**
 * @api
 * @since 100.0.2
 */
class Form extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
     * Prepare form
     *
     * @param DataForm $form
     * @param ModelCode|null $experimentCodeModel
     * @param string $formName
     * @return void
     */
    public function addGoogleoptimizerFields(DataForm $form, ?ModelCode $experimentCodeModel = null, $formName = '')
    {
        $fieldset = $form->addFieldset(
            'googleoptimizer_fields',
            ['legend' => __('Google Analytics Content Experiments Code')]
        );

        $fieldset->addField(
            'experiment_script',
            'textarea',
            [
                'name' => 'experiment_script',
                'label' => __('Experiment Code'),
                'value' => $experimentCodeModel ? $experimentCodeModel->getExperimentScript() : '',
                'class' => 'textarea googleoptimizer',
                'required' => false,
                'note' => __('Experiment code should be added to the original page only.'),
                'data-form-part' => $formName
            ]
        );

        $fieldset->addField(
            'code_id',
            'hidden',
            [
                'name' => 'code_id',
                'value' => $experimentCodeModel ? $experimentCodeModel->getCodeId() : '',
                'required' => false,
                'data-form-part' => $formName
            ]
        );

        $form->setFieldNameSuffix('google_experiment');
    }
}
