<?php
/**
 * Copyright 2020 Adobe
 * All Rights Reserved.
 */

declare(strict_types=1);

namespace Magento\Elasticsearch\Setup\Patch\Data;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Indexer\IndexerRegistry;
use Magento\CatalogSearch\Model\Indexer\Fulltext as FulltextIndexer;
use Magento\Framework\Setup\Patch\PatchInterface;

/**
 * Invalidate fulltext index
 */
class InvalidateIndex implements DataPatchInterface
{
    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @var IndexerRegistry
     */
    private $indexerRegistry;

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param IndexerRegistry $indexerRegistry
     */
    public function __construct(ModuleDataSetupInterface $moduleDataSetup, IndexerRegistry $indexerRegistry)
    {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->indexerRegistry = $indexerRegistry;
    }

    /**
     * @inheritDoc
     */
    public function apply(): PatchInterface
    {
        $this->indexerRegistry->get(FulltextIndexer::INDEXER_ID)->invalidate();
        return $this;
    }

    /**
     * @inheritDoc
     */
    public static function getDependencies(): array
    {
        return [];
    }

    /**
     * @inheritDoc
     */
    public function getAliases(): array
    {
        return [];
    }
}
