<?php
/**
 * Copyright 2015 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

/**
 * Tests for \Magento\Framework\Data\Form\Field\Regexceptions
 */
namespace Magento\Config\Test\Unit\Block\System\Config\Form\Field;

use Magento\Config\Block\System\Config\Form\Field\Regexceptions;
use Magento\Framework\Data\Form\Element\AbstractElement;
use Magento\Framework\Data\Form\Element\Factory;
use Magento\Framework\TestFramework\Unit\Helper\ObjectManager;
use Magento\Framework\TestFramework\Unit\Helper\MockCreationTrait;
use Magento\Framework\View\Design\Theme\Label;
use Magento\Framework\View\Design\Theme\LabelFactory;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class RegexceptionsTest extends TestCase
{
    use MockCreationTrait;

    /**
     * @var array
     */
    protected $cellParameters;

    /**
     * @var MockObject
     */
    protected $labelFactoryMock;

    /**
     * @var MockObject
     */
    protected $labelMock;

    /**
     * @var MockObject
     */
    protected $elementFactoryMock;

    /**
     * @var MockObject
     */
    protected $elementMock;

    /**
     * @var Regexceptions
     */
    protected $object;

    /**
     * @var ObjectManager
     */
    private $objectManager;

    protected function setUp(): void
    {
        $this->cellParameters = [
            'size'  => 'testSize',
            'style' => 'testStyle',
            'class' => 'testClass',
        ];

        $this->objectManager = new ObjectManager($this);

        $this->labelFactoryMock = $this->createMock(LabelFactory::class);
        $this->labelMock = $this->createMock(Label::class);
        $this->elementFactoryMock = $this->createMock(Factory::class);
        $this->elementMock = $this->createPartialMockWithReflection(
            AbstractElement::class,
            [
                'setName', 'setHtmlId', 'setValues', 'getValues',
                'setForm', 'getName', 'getHtmlId', 'getElementHtml'
            ]
        );

        $data = [
            'elementFactory' => $this->elementFactoryMock,
            'labelFactory'   => $this->labelFactoryMock,
            'data'           => [
                'element' => $this->elementMock
            ],
        ];
        $this->objectManager->prepareObjectManager();
        $this->object = $this->objectManager->getObject(
            Regexceptions::class,
            $data
        );
    }

    public function testRenderCellTemplateValueColumn()
    {
        $columnName     = 'value';
        $expectedResult = 'testValueElementHtml';

        $this->elementFactoryMock->expects($this->once())->method('create')->willReturn($this->elementMock);
        $this->elementMock->expects($this->once())->method('setForm')->willReturnSelf();
        $this->elementMock->expects($this->once())->method('setName')->willReturnSelf();
        $this->elementMock->expects($this->once())->method('setHtmlId')->willReturnSelf();
        $this->elementMock->expects($this->once())->method('setValues')->willReturnSelf();
        $this->elementMock->expects($this->once())->method('getElementHtml')->willReturn($expectedResult);

        $this->labelFactoryMock->expects($this->once())->method('create')->willReturn($this->labelMock);
        $this->labelMock->expects($this->once())->method('getLabelsCollection')->willReturn([]);

        $this->object->addColumn(
            $columnName,
            $this->cellParameters
        );

        $this->assertEquals(
            $expectedResult,
            $this->object->renderCellTemplate($columnName)
        );
    }

    public function testRenderCellTemplateOtherColumn()
    {
        $columnName     = 'testCellName';

        $this->object->addColumn(
            $columnName,
            $this->cellParameters
        );

        $actual = $this->object->renderCellTemplate($columnName);
        foreach ($this->cellParameters as $parameter) {
            $this->assertStringContainsString(
                $parameter,
                $actual,
                'Parameter \'' . $parameter . '\' missing in render output.'
            );
        }
    }

    public function testRenderCellTemplateWrongColumnName()
    {
        $columnName      = 'testCellName';
        $wrongColumnName = 'wrongTestCellName';

        $this->object->addColumn($wrongColumnName, $this->cellParameters);

        $this->expectException('\Exception');
        $this->expectExceptionMessage('Wrong column name specified.');

        $this->object->renderCellTemplate($columnName);
    }
}
