<?php
/**
 * Copyright 2017 Adobe
 * All Rights Reserved.
 */
namespace Magento\CatalogUrlRewrite\Model\Map;

use Magento\Framework\ObjectManagerInterface;

/**
 * Pool for hash maps
 */
class HashMapPool
{
    /**
     * @var HashMapInterface[]
     */
    private $dataArray = [];

    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * Constructor
     *
     * @param ObjectManagerInterface $objectManager
     */
    public function __construct(
        ObjectManagerInterface $objectManager
    ) {
        $this->objectManager = $objectManager;
    }

    /**
     * Gets a map by instance and category Id
     *
     * @param string $instanceName
     * @param int $categoryId
     * @return HashMapInterface
     * @throws \Exception
     */
    public function getDataMap($instanceName, $categoryId)
    {
        $key = $instanceName . '-' . $categoryId;
        if (!isset($this->dataArray[$key])) {
            $instance = $this->objectManager->create(
                $instanceName,
                [
                    'category' => $categoryId
                ]
            );
            if (!$instance instanceof HashMapInterface) {
                throw new \InvalidArgumentException(
                    $instanceName . ' does not implement interface ' . HashMapInterface::class
                );
            }
            $this->dataArray[$key] = $instance;
        }
        return $this->dataArray[$key];
    }

    /**
     * Resets data in a hash map by instance name and category Id
     *
     * @param string $instanceName
     * @param int $categoryId
     * @return void
     */
    public function resetMap($instanceName, $categoryId)
    {
        $key = $instanceName . '-' . $categoryId;
        if (isset($this->dataArray[$key])) {
            $this->dataArray[$key]->resetData($categoryId);
            unset($this->dataArray[$key]);
        }
    }
}
