<?php
/**
 * Copyright 2018 Adobe
 * All Rights Reserved.
 */
declare(strict_types=1);

namespace Magento\CatalogGraphQl\Model\Resolver\Products\DataProvider\Product;

use Magento\Catalog\Model\ResourceModel\Product\Collection;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\GraphQl\Model\Query\ContextInterface;

/**
 * {@inheritdoc}
 */
class CompositeCollectionProcessor implements CollectionProcessorInterface
{
    /**
     * @var CollectionProcessorInterface[]
     */
    private $collectionProcessors;

    /**
     * @param CollectionProcessorInterface[] $collectionProcessors
     */
    public function __construct(array $collectionProcessors = [])
    {
        $this->collectionProcessors = $collectionProcessors;
    }

    /**
     * Process collection to add additional joins, attributes, and clauses to a product collection.
     *
     * @param Collection $collection
     * @param SearchCriteriaInterface $searchCriteria
     * @param array $attributeNames
     * @param ContextInterface|null $context
     * @return Collection
     */
    public function process(
        Collection $collection,
        SearchCriteriaInterface $searchCriteria,
        array $attributeNames,
        ?ContextInterface $context = null
    ): Collection {
        foreach ($this->collectionProcessors as $collectionProcessor) {
            $collection = $collectionProcessor->process($collection, $searchCriteria, $attributeNames, $context);
        }

        return $collection;
    }
}
